#include "dm_gpio.h"
#include <linux/gpio.h>

void DmInitGPIO( void ) {}
void DmDeInitGPIO( void ) {}
INT32 DmSetGPIO( UINT32 iIndex, BOOL bHigh )
{
    int err = gpio_request(iIndex, "dm_gpio");
    if(err) {
        //pr_warn("Failed to get dm_gpio: %u\n", iIndex);
        /* Continue, since this isn't a fatal error */
    }
    //pr_info("set_gpio %i = %s\n", iIndex, bHigh ? "high" : "low");
    gpio_direction_output(iIndex, bHigh);
    gpio_free(iIndex);
    return err;
}
BOOL DmReadGPIO( UINT32 iIndex )
{
    int err = gpio_request(iIndex, "dm_gpio");
    BOOL val = false;
    if(err) {
        //pr_warn("Failed to get dm_gpio: %u\n", iIndex);
        /* Continue, since this isn't a fatal error */
    }
    val = gpio_get_value(iIndex);
    gpio_free(iIndex);
    return val;
}
